import { View, Text, FlatList, StyleSheet, Pressable } from "react-native";
import React from "react";
import Ellipse2 from "../../../assets/svgs/home/Ellipse/Ellipse2.svg";
import Ellipse3 from "../../../assets/svgs/home/Ellipse/Ellipse3.svg";
import Ellipse4 from "../../../assets/svgs/home/Ellipse/Ellipse4.svg";
import Ellipse5 from "../../../assets/svgs/home/Ellipse/Ellipse5.svg";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { useNavigation } from "@react-navigation/native";

import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../../hooks/useLangTranslation";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const RenderItem = ({ item }) => {
    const navigation = useNavigation();
    const { Ellipse, text, value } = item;
    const url = `${BASE_API_URL_STG}/user/product-categorized/${value}`;

    return (
        <Pressable
            style={featureStyle.singleContainer}
            onPress={() =>
                navigation.navigate("feature display", {
                    name: item.text,
                    url,
                })
            }
        >
            <View style={featureStyle.iconCont}>
                <CustomSVG svgIcon={Ellipse} width={dpr(30)} height={dpr(30)} />
            </View>
            <Text style={featureStyle.text}>
                {text}
            </Text>
        </Pressable>
    );
};

const Feature = () => {
    const { trans } = useLangTranslation();

    const features = [
        {
            Ellipse: Ellipse2,
            text: trans("New Arrivals"),
            value: "newArrivals",
        },
        {
            Ellipse: Ellipse3,
            text: trans("Best Seller"),
            value: "bestSeller",
        },
        {
            Ellipse: Ellipse4,
            text: trans("Most Popular"),
            value: "popularProducts",
        },
        {
            Ellipse: Ellipse5,
            text: trans("Flash Sales"),
            value: "flashSales",
        },
    ];

    return (
        <View style={featureStyle.container}>
            <FlatList
                data={features}
                keyExtractor={(_, i) => "key" + i}
                renderItem={({ item }) => <RenderItem item={item} />}
                horizontal={true}
                showsHorizontalScrollIndicator={false}
            />
        </View>
    );
};

const featureStyle = StyleSheet.create({
    container: {
        flex: 1,
        alignItems: "center",
        justifyContent: "space-between",
        width: dpr("wf") - dpr(40),
    },
    singleContainer: {
        flexDirection: "column",
        alignItems: "center",
        width: (dpr("wf") - dpr(40)) / 4,
        marginTop: dpr(15),
    },
    iconCont: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        height: dpr(54),
        width: dpr(54),
        borderRadius: 50,
        marginBottom: dpr(10),
        position: "relative",
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    text: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#898989",
        textAlign: "center",
        marginTop: dpr(5),
        lineHeight: dpr(18),
        alignSelf: "center",
    },
});

export default Feature;
